<?php
    // Incluir conexión (asegúrate que $coneccion se llame así en tu archivo)
    include 'conexion.php';

    // Verificación básica de conexión
    if (!$coneccion) {
        die("ERROR: No se pudo conectar a la base de datos.");
    }

    // 1. Recibir datos de forma segura (Previene errores de PHP 8.2)
    // Usamos intval() para asegurar que sean números. Si están vacíos, serán 0.
    $id_empresa = isset($_POST['id']) ? intval($_POST['id']) : 0;
    $mes        = isset($_POST['mes']) ? intval($_POST['mes']) : 0;
    $anio       = isset($_POST['anio']) ? intval($_POST['anio']) : 0;

    // Opcional: Si alguno es 0, podemos detenernos (o dejar que busque y no encuentre nada)
    /*
    if ($id_empresa == 0 || $mes == 0 || $anio == 0) {
        echo "0"; // Faltan datos
        exit;
    }
    */

    // 2. Consulta SQL segura
    // Al haber usado intval arriba, ya no necesitamos comillas en el SQL y es seguro.
    $sql = "SELECT * FROM det_cobros WHERE id_empresa = $id_empresa AND mes = $mes AND anio = $anio";

    // 3. Ejecutar consulta con manejo de errores
    $query = mysqli_query($coneccion, $sql);

    if (!$query) {
        // Esto te ayudará a ver si hay un error en la tabla o campos
        die("Error en la consulta SQL: " . mysqli_error($coneccion));
    }

    // 4. Obtener resultados
    $row_cnt = mysqli_num_rows($query);
    $row = mysqli_fetch_assoc($query);

    // Cerrar conexión para liberar memoria
    mysqli_close($coneccion);

    // 5. Lógica de respuesta
    if ($row_cnt == 1) {
        // Si encontró exactamente 1 pago, devuelve el total
        // Verificamos que la clave 'total' exista para evitar error
        echo isset($row['total']) ? $row['total'] : "Error: Columna total no encontrada";
        
    } elseif ($row_cnt > 1) {
        // Si hay duplicados
        echo "-1";
        
    } else {
        // No se encontró nada (0 resultados)
        echo "0";
    }
?>