<?php

// Including all required classes

//require_once('class/BCGFontFile.php');// server
require_once($_SERVER["DOCUMENT_ROOT"].'/comercio/php/barcodegen2/class/BCGFontFile.php'); //local

//require_once('class/BCGColor.php');// server
require_once($_SERVER["DOCUMENT_ROOT"].'/comercio/php/barcodegen2/class/BCGColor.php');  //local

//require_once('class/BCGDrawing.php'); //server
require_once($_SERVER["DOCUMENT_ROOT"].'/comercio/php/barcodegen2/class/BCGDrawing.php');  //local

// Including the barcode technology
//require_once('class/BCGcode128.barcode.php'); //server
require_once($_SERVER["DOCUMENT_ROOT"].'/comercio/php/barcodegen2/class/BCGcode128.barcode.php'); //local 


function GenerarImagen($archivo, $codigo){

	// Loading Font

	//$font = new BCGFontFile('barcodegen2/class/font/Arial.ttf',8); //server
    $font = new BCGFontFile($_SERVER["DOCUMENT_ROOT"].'/comercio/php/barcodegen2/class/font/Arial.ttf',8); //local
	

	// The arguments are R, G, B for color.

	$color_black = new BCGColor(0, 0, 0);

	$color_white = new BCGColor(255, 255, 255);

	

	$drawException = null;

	try {

		$code = new BCGcode128();

		$code->setScale(1); // Resolution

		$code->setThickness(30); // Thickness

		$code->setForegroundColor($color_black); // Color of bars

		$code->setBackgroundColor($color_white); // Color of spaces

		$code->setFont($font); // Font (or 0)

		$code->parse($codigo); // Text

	} catch(Exception $exception) {

		$drawException = $exception;

	}

	

	/* Here is the list of the arguments

	1 - Filename (empty : display on screen)

	2 - Background color */

	$drawing = new BCGDrawing($archivo, $color_white);

	if($drawException) {

		$drawing->drawException($drawException);

	} else {

		$drawing->setRotationAngle(90);

		$drawing->setDPI(72);

	

		$drawing->setBarcode($code);

		$drawing->draw();

	}

	

	// Header that says it is an image (remove it if you save the barcode to a file)

	//header('Content-Type: image/png');

	

	// Draw (or save) the image into PNG format.

	$drawing->finish(BCGDrawing::IMG_FORMAT_PNG);



}





?>