<?php

/*
// --- BLOQUE DE DIAGNÓSTICO (Borrar al terminar) ---
echo "<pre style='background: #000; color: #0f0; padding: 20px; z-index:99999; position:relative;'>";
echo "<h1>DIAGNÓSTICO DE DATOS RECIBIDOS</h1>";

echo "<h3>1. ESTADO DE LA IMAGEN (\$_FILES):</h3>";
if (isset($_FILES['file-upload'])) {
    print_r($_FILES['file-upload']);
} else {
    echo "ERROR CRÍTICO: No llegó ninguna imagen. Revisa el 'enctype' en tu formulario.";
}

echo "<hr><h3>2. LISTA DE COMPROBANTES (\$_POST['lista']):</h3>";
if (!empty($_POST['lista'])) {
    print_r($_POST['lista']);
} else {
    echo "ERROR CRÍTICO: La lista está VACÍA. El checkbox no se envió.";
}

echo "<hr><h3>3. OTROS DATOS (\$_POST):</h3>";
print_r($_POST);

echo "</pre>";
die("--- FIN DEL DIAGNOSTICO ---");
// --------------------------------------------------
*/

ob_start();
session_start();

// Inicialización de variables POST para PHP 8.2
$mes  = isset($_POST['mes']) ? intval($_POST['mes']) : 0;
$anio = isset($_POST['anio']) ? intval($_POST['anio']) : 0;
$id_empresa = $_POST['id_empresa'] ?? 0;

// Validación de tipo de formulario
if (isset($_POST['tipo_formulario'])) {
    $tipo_formulario = intval($_POST['tipo_formulario']);
} elseif (isset($_POST['tipo_f'])) {
    $tipo_formulario = intval($_POST['tipo_f']);
} else {
    $tipo_formulario = 0;
}  

$vuelve = false;
$nombre_archivo = $_POST['nombre_imagen'] ?? '';

if ($nombre_archivo == ''){
    print "<script>alert('Falta Seleccionar la Imagen!!!')</script>"; 
    $vuelve = true;
} 

if ($vuelve == true){
    echo "<script LANGUAGE='JavaScript'>
       function redireccionar() { history.back(1); }
       setTimeout ('redireccionar()', 0);
       </script>";
}

$message = "";
$fileExtension = "";
$newFileName = "";

// Procesamiento de Imagen
if (isset($_FILES['file-upload']) && $_FILES['file-upload']['error'] === UPLOAD_ERR_OK)
{
    $fileTmpPath = $_FILES['file-upload']['tmp_name'];
    $fileName = $_FILES['file-upload']['name'];
    $fileNameCmps = explode(".", $fileName);
    $fileExtension = strtolower(end($fileNameCmps));
}

// Lista de comprobantes
$lista = $_POST['lista'] ?? [];

// Aseguramos que comprobantes sea un array válido
if (!isset($comprobantes)) {
    $comprobantes = isset($lista) ? $lista : [];
}

if (is_array($comprobantes) && !empty($comprobantes)) {
     foreach($comprobantes as $seleccion) {
      $porciones = explode(",", $seleccion);
      $tipo_formulario = $porciones['0'] ?? $tipo_formulario;
      $anio = $porciones['1'] ?? $anio;
      $mes = $porciones['2'] ?? $mes;
      $total_formulario= $porciones['3'] ?? 0;
    }
}

 // Variables del formulario POST
 $total_formulario = isset($_POST['importe']) ? $_POST['importe'] : 0;
 $total_todos      = isset($_POST['total_pago']) ? $_POST['total_pago'] : 0;
 $total_pago       = isset($_POST['total_pago']) ? $_POST['total_pago'] : 0;
 $id_banco         = $_POST['banco'] ?? 0;
 $usuario          = $_POST['cuit'] ?? '';
 $comprobante      = $_POST['comprobante'] ?? '';
 $fecha            = $_POST['fecha'] ?? '';
 $pagoParcial      = $_POST["pagoParcial"] ?? null;
 
 $estado = "1";
 $activo = "1";

// Validaciones
if ($mes < 1) $vuelve = true;
if ($total_pago == 0) $vuelve = true;
if ($fecha == '') $vuelve = true;
if ($id_banco == 0) $vuelve = true;
if ($comprobante == '') $vuelve = true;

if ($vuelve == true){
    echo "<script LANGUAGE='JavaScript'>
       alert('Error en los datos ingresados (Fecha, Banco, Comprobante o Importe). Verifique.');
       function redireccionar() { history.back(1); }
       setTimeout ('redireccionar()', 0);
       </script>";
}

$allowedfileExtensions = array('jpg','jpeg', 'gif', 'png');

if (in_array($fileExtension, $allowedfileExtensions))
{   
    $uploadFileDir = 'comprobantes/';
    if (!is_dir($uploadFileDir)) mkdir($uploadFileDir, 0777, true); // Crear carpeta si no existe
    
    $newFileName = 'CP'. $id_empresa .'-'. $anio .'-' . $mes.'-'. $tipo_formulario. '.'.  $fileExtension;
    $dest_path = $uploadFileDir . $newFileName;
    
    if(move_uploaded_file($fileTmpPath, $dest_path)) {
        $message ='Movido';
    } else {
        $message = 'Error No se pudo Subir la imagen';
    }
}
else
{
    if (!$vuelve) { 
        print "<script>alert('Archivo de Imagen Incorrecto o No Seleccionado !!!')</script>"; 
        $vuelve = true;
    }
}

if ($message <> 'Movido'){
     $vuelve = true;
     echo "<script LANGUAGE='JavaScript'>
         alert('Error al subir la imagen: $message');
         function redireccionar() { history.back(1); }
         setTimeout ('redireccionar()', 0);
       </script>";
}

$Registros = 0;

if ($vuelve == false){
    date_default_timezone_set('America/Argentina/Buenos_Aires');  

    $total_pago = str_replace(',','',$total_pago); 
    $Subtotal = $total_pago;
    
    include 'conexion.php';
    
    if (!$coneccion) die("Error de conexión: " . mysqli_connect_error());
  
  foreach($comprobantes as $seleccion) {
      $Registros += 1;
      $porciones = explode(",", $seleccion);
      $tipo_formulario = $porciones['0'];
      $anio = $porciones['1'];
      $mes = $porciones['2'];
      $total_formulario= $porciones['3'];

      if($Subtotal >=$total_formulario ){
         $total_pago = $total_formulario;
      }else {
         $total_pago =$Subtotal;
      }
      $Subtotal -= $total_formulario;

      // Buscamos si existe
      $_pagi_sql = "SELECT * FROM com_depositos WHERE id_tipo_formulario = $tipo_formulario AND id_empresa = $id_empresa AND mes = $mes AND anio = $anio AND comprobante = '$comprobante'";

      $query = mysqli_query($coneccion ,  $_pagi_sql);
      $row_exists = mysqli_fetch_array($query);
     
      if ($row_exists)
      {
            // ACTUALIZAR
            $sql = "UPDATE com_depositos SET id_banco = '$id_banco', importe = $total_pago, total = $total_formulario, fecha = '$fecha', archivo = '$newFileName' WHERE id_tipo_formulario = $tipo_formulario AND id_empresa = $id_empresa AND mes = $mes AND anio = $anio AND comprobante = '$comprobante'";
            $query_update = mysqli_query($coneccion,$sql);
      }
      else
      {
            // INSERTAR
           $sql = "INSERT INTO com_depositos (comprobante, id_tipo_formulario, id_empresa, mes, anio, id_banco, importe, total, fecha, archivo, activo, usuario_actualizacion) VALUES ('$comprobante','$tipo_formulario', '$id_empresa', '$mes', '$anio', '$id_banco', '$total_pago','$total_formulario','$fecha', '$newFileName','$activo', '$usuario')";

           $query_update = mysqli_query($coneccion,$sql);                  
      }

      // DEBUG DE SQL: Si falla, muere aquí y muestra el error
      if ($query_update == false){
            die("ERROR SQL CRITICO: " . mysqli_error($coneccion) . " --- SQL: " . $sql);
      }
  }   

  // --- PREPARACION PARA PDF ---
  
  // 1. Recargar datos frescos
  $sql_pdf = "SELECT f.id_empresa, f.mes, f.anio, f.bancodepo, f.cant_empleados, f.imp_remuneracion, 
              f.cant_art_100, f.imp_art_100, f.imp_art_101, f.cant_art_101, f.otros, f.id_tipo_formulario,
              f.imp_otros, f.tipo_pago, f.enletras, f.bancopago, f.nro_cheque, f.fecha, 
              f.cod_barra, e.nombre as empresa, e.cuit, e.direccion, e.telefono, m.descripcion as municipio 
              FROM com_formularios f 
              LEFT JOIN com_empresas e ON f.id_empresa = e.id_empresa 
              LEFT JOIN com_municipios m ON e.id_municipio = m.id_municipio 
              WHERE f.id_tipo_formulario = $tipo_formulario 
              AND f.id_empresa = $id_empresa 
              AND f.mes = $mes 
              AND f.anio = $anio";
              
   $query_pdf = mysqli_query($coneccion, $sql_pdf);
   
   if ($query_pdf) {
       $row = mysqli_fetch_array($query_pdf);
       
       // 2. Inyectar datos del pago actual en $row por si el PDF los lee de ahí
       $row['fecha'] = $fecha;
       $row['comprobante'] = $comprobante; 
       $row['bancopago'] = $id_banco; 
       // Forzamos el id_banco (Lugar de pago) que acabamos de guardar
       $row['bancodepo'] = $id_banco; 
   }

   // 3. Mapear variables que comprobante2.php necesita
   $Importe_NC = 0; // O el valor que corresponda si viene por POST
   $Lugar_Pago = $id_banco; // Fundamental para que el PDF sepa que es Pago Facil
   $CBU = ""; // O $_POST['cbu'] si existe

   // 4. LIMPIEZA FINAL DE BUFFER
   // Esto borra cualquier "echo", "alert" o espacio en blanco anterior.
   // Deja el canal limpio para que el PDF se genere sin errores de estructura.
   ob_end_clean(); 
   
   // 5. Generar PDF
   mysqli_close($coneccion);   
   require_once("php/comprobante2.php");
   exit; // Terminamos el script aquí
}
// Si no entró al if ($vuelve == false), limpiamos buffer y mostramos lo que haya
ob_end_flush();
?>